---------------------------------------------
-- added to compile below
---------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
---------------------------------------------
PACKAGE math IS
  TYPE tw32 IS ARRAY(31 DOWNTO 0) OF std_logic;
  FUNCTION tw_add(a, b : tw32) RETURN tw32;
  FUNCTION tw_sub(a, b : tw32) RETURN tw32;
END math;

USE WORK.math.ALL;
LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
ENTITY cpu IS
  PORT( clk, interrupt : IN std_logic;
        addr : OUT tw32; cont : IN INTEGER;
        data : INOUT tw32 );
END cpu;

ARCHITECTURE cpu_blk OF cpu IS
  SIGNAL ibus, dbus : tw32;
BEGIN
  ALU : BLOCK
    PORT( abus, bbus : IN tw32;
          d_out : OUT tw32;
          ctbus : IN INTEGER);
    PORT MAP ( abus => ibus, bbus => dbus, d_out => data, 
               ctbus => cont);
    SIGNAL qbus : tw32;
  BEGIN
    d_out <= tw_add(abus, bbus) WHEN ctbus = 0 ELSE
             tw_sub(abus, bbus) WHEN ctbus = 1 ELSE
             abus;
  END BLOCK ALU;
END cpu_blk; 

